import asyncio
from bleak import BleakScanner

UART_SERVICE_UUID = "19F8ADE2-D0C6-4C0A-912A-30601D9B3060"


async def run():
    def filter_by_uuid(device, advertisement_data):
        if UART_SERVICE_UUID in advertisement_data.service_uuids:
            return True
        return False

    print("Discovering Tail Company devices nearby...\n")

    async with BleakScanner(detection_callback=None, advertisment_data_filter=True) as scanner:
        devices = await scanner.discover()

    for device in devices:
        if device.name == "mitail" or device.name == "minitail" or device.name == "flutter" or device.name == "EG2":
            print(device.name, device.address)

if __name__ == '__main__':
    loop = asyncio.new_event_loop()
    asyncio.set_event_loop(loop)

    loop.run_until_complete(run())
